//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function q2=%CLquat_i_CLquat(v,q1,q2)

// LAST UPDATE
// 10/12/2007
//

// Declarations:


// Code:

sq1 = size(q1);
sq2 = size(q2);

if (min(v)<1 | max(v)>sq2) | (size(v)~=sq1) then CL__error("invalid index..."); end

if v~=[]
  r = q2.r;
  im = q2.i;

  r(:,v) = q1.r;
  im(:,v) = q1.i;

  q2 = CL_rot_defQuat(r,im);
end

endfunction
